/***********************************************************************
 *
 * Copyright (c) 2002 PalmSource, Inc. or its subsidiaries.
 * All rights reserved.
 *
 ***********************************************************************
 *
 * FILE: CharSet.h
 *
 *
 * DESCRIPTION:
 *
 *
 * AUTHOR:
 *	September	25, 2002	Created by Yann Cheri (YCh)
 *	mmmm dd, yyyy	Now owned by .....
 *
 ***********************************************************************/
#ifndef CHARSETSTRING_H
#define CHARSETSTRING_H

#include <afx.h>		// CString
#include "ShTarget.h"


/////////////////
// CharSet Ids //
/////////////////
#define kCharSetGSMId	0
#define kCharSetHEXId	1
#define kCharSetIRAId	2	
#define kCharSetPCCPId	3
#define kCharSetPCDNId	4
#define kCharSetUCS2Id	5
#define kCharSet8859nId	6
#define kCharSet8859CId	7
#define kCharSet8859AId	8
#define kCharSet8859GId	9
#define kCharSet8859HId	10

#define kCharSetSMS7Id	97
#define kCharSetSMS8Id	98
#define kCharSetASCIIId	99
///////////////////
// CharSet Names //
///////////////////
#define kCharSetGSM		"GSM"		// GSM default alphabet (GSM 03.38 subclause 6.2.1)
#define kCharSetHEX		"HEX"		// Character strings consist only of hexadecimal numbers from 00 to FF;
									// No conversions to the original ME character set shall be done.
									// NOTE: If ME is using GSM default alphabet, its characters shall be padded
									//		 with 8th bit (zero) before converting them to hexadecimal numbers
									//		 (i.e. no SMS-style packing of 7-bit alphabet).
#define kCharSetIRA		"IRA"		// International reference alphabet (ITU-T T.50 [13])
									// ETSI TS 100 916 V7.5.0 (1999-12) 16 (GSM 07.07 version 7.5.0 Release 1998)
#define kCharSetPCCP	"PCCPxxx"	// PC character set Code Page xxx
#define kCharSetPCDN	"PCDN"		// PC Danish/Norwegian character set
#define kCharSetUCS2	"UCS2"		// 16-bit universal multiple-octet coded character set (ISO/IEC10646 [32]);
									// UCS2 character strings are converted to hexadecimal numbers from 0000 to FFFF;
#define kCharSet8859n	"8859-n"	// ISO 8859 Latin n (1-6) character set
#define kCharSet8859C	"8859-C"	// ISO 8859 Latin/Cyrillic character set
#define kCharSet8859A	"8859-A"	// ISO 8859 Latin/Arabic character set
#define kCharSet8859G	"8859-G"	// ISO 8859 Latin/Greek character set
#define kCharSet8859H	"8859-H"	// ISO 8859 Latin/Hebrew character set
//#define kCharSetASCII	"ASCII"		// ASCII
//#define kCharSetSMS7	"SMS7"		// SMS 7 bits
//#define kCharSetSMS8	"SMS8"		// SMS 8 bits

#define kDefaultCharSetId	kCharSetGSMId


////////////////////////
// Data Coding Scheme //
////////////////////////
#define kDCSDefault		0			// 7 bits
#define kDCS8Bits		4
#define kDCSUCS2		8

///////////////////////////////
///////////////////////////////
#define kUCS2DefaultChar			0x20
#define kGSMDefaultChar				0xFF
#define kPlatformToGSMSize			256
#define kUnknownChar				0x00
#define kGSMToPlatformSize			129
///////////////////////////////
// CharSet Class Error Codes //
///////////////////////////////
#define kCharSetNotSupported	0
#define kCharSetSupported		1
#define kCharSetInvalid			2

///////////////////////
// CharSet Structure //
///////////////////////
typedef struct {
	int		charSetId;
	char*	charSetNameP;
	bool	charSetSupported;
}CharSetType, *CharSetPtr;

/////////////////////////////////////////////////////////////////////////////
class CCharSetString: public CString
{
private:
	CString mCharSet;
	static char	SMS8BitConversionTable[];	// Used for ASCII -> SMS8Bits conversions

	static CharSetType charSetTable[];
	static int  charSetTableSize;

	static CharSetType charSetSMSTable[];
	static int  charSetSMSTableSize;

	int		currentStringCharSet;
	int		currentPhoneCharSet;

	bool	currentStringIsSMS;
	int		currentSMSStringLength;

	void	PrvConstructor(CString iCharSet);
	int		PrvCharSetGetNameFromId(int iCharSetId, CString* ioCharSetNameP);
	int		PrvCharSetGetIdFromName(CString iCharSetName, int* ioCharSetIdP);

	UInt32	PrvConvertBitsOps(UInt8 src, UInt32 pos, char *d);
	UInt8	PrvConvertNibbleToDec(UInt8 cdata);
	void	PrvConvertToCharset(UInt8 aDefaultChar, UInt8 *aConversionTable, UInt16 aTableLen, UInt8 anUnknownChar);
public:
	// constructs empty CCharSetString
	CCharSetString(CString iCharSet);
	CCharSetString();
	// copy constructor
	CCharSetString(CString iCharSet, const CString& stringSrc);
	CCharSetString(CString iCharSet, LPCSTR lpch, int nLength);	

	int		GetStringLength(void);
	int		GetGSMStringLength(void);
	int		GetSMSStringLength(void);
	
	int		IsDataCodingSchemeSupported(int iDCSId);
	int		IsCharSetSupported(int iCharSetId);
	int		IsCharSetSupported(CString iCharSetName);
	int		IsCharSetSMSSupported(int iCharSetId);

	void	GetSupportedCharSetList(void);
	int		GetCurrentPhoneCharSet(void);

	void	PrepareStringToStorage(void);

	int		SetCurrentStringCharSet(int iCharSetId);
	int		SetCurrentStringCharSet(CString iCharSetName);
	int		GetCurrentStringCharSet(void);

	int		ConvertStringToCharSet(int iCharSetId);
	int		ConvertStringToCharSet(CString iCharSetName);
	int		ConvertStringToCurrentPhoneCharSet();
	
	int		ConvertStringToSMSCharSet(int iCharSetId);
	int		ConvertStringToSMSCharSet(int iCharSetId, int iBitBoundary);
	int		ConvertSMSCharSetToString(int iCharSetId);
	int		ConvertSMSCharSetToString(int iCharSetId, int iSMSStringLength, int iOffSet, int iBitBoundary);

	void	ConvertStringToGSM(void);
	void	ConvertGSMToString(void);

	int		ConvertStringToUCS2(void);
	int		ConvertUCS2ToString(UInt8 iDefaultChar, Bool iForceConversion);

	int		ConvertStringToSMS8(void);
	int		ConvertStringToSMS7(void);
	int		ConvertStringToSMS7Packed(UInt8 iBitBoundary);
	int		ConvertSMS7PackedToString(UInt16 iStringLength, UInt8 iOffset, UInt8 iBitBoundary);

	void	ConvertByteHexaToString(UInt8 iByte, Int8* ioHexaByteStringP);
	void	ConvertByteToChar(UInt8 iByte, Int8* ioHexaChar);
	int		ConvertStringToDCB(UInt16* ioLength);
	int		ConvertStringToBCD(UInt16 iBufLen);

	void	ConvertAsciiToDiallingNumberString(void);

	CString GetMECharSet(){return mCharSet;};

};
/////////////////////////////////////////////////////////////////////////////
#endif
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////